/*
 * Decompiled with CFR 0.152.
 */
package net.pevori.queencats.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.Team;
import net.pevori.queencats.QueenCats;
import net.pevori.queencats.entity.custom.HumanoidAnimalEntity;
import net.pevori.queencats.entity.custom.HumanoidCatEntity;
import net.pevori.queencats.entity.custom.HumanoidDogEntity;
import net.pevori.queencats.entity.variants.HumanoidBunnyVariant;
import net.pevori.queencats.item.ModItems;
import net.pevori.queencats.sound.ModSounds;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class HumanoidBunnyEntity
extends HumanoidAnimalEntity
implements IAnimatable {
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected Item itemForTaming = (Item)ModItems.GOLDEN_WHEAT.get();
    protected Item itemForGrowth = (Item)ModItems.KEMOMIMI_POTION.get();
    protected Ingredient itemForHealing = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_, Items.f_42405_, (ItemLike)ModItems.GOLDEN_WHEAT.get(), Items.f_42677_});
    protected Ingredient equippableArmor = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42408_, Items.f_42465_, Items.f_42477_, Items.f_42469_, Items.f_42473_, Items.f_42481_});
    public static final String pekoSan = "pekora";
    protected static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(HumanoidBunnyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(HumanoidBunnyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    protected HumanoidBunnyEntity(EntityType<? extends HumanoidAnimalEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean isAlmond() {
        String s = this.m_7755_().getString();
        return s != null && s.toLowerCase().contains(pekoSan);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ModItems.KEMOMIMI_POTION.get();
    }

    protected SoundEvent m_7515_() {
        if (!QueenCats.enableBunnySounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_BUNNY_AMBIENT.get();
    }

    public SoundEvent m_7866_(ItemStack stack) {
        if (!QueenCats.enableBunnySounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_BUNNY_EAT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if (!QueenCats.enableBunnySounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_BUNNY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        if (!QueenCats.enableBunnySounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_BUNNY_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12354_, 0.15f, 1.0f);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isSitting()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoidbunny.sitting", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoidbunny.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoidbunny.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationEvent event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoidbunny.attack", Boolean.valueOf(false)));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 0.0f, this::attackPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        this.m_21839_(sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    @Override
    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (target instanceof Creeper || target instanceof Ghast) {
            return false;
        }
        if (target instanceof HumanoidBunnyEntity) {
            HumanoidBunnyEntity humanoidBunnyEntity = (HumanoidBunnyEntity)target;
            return !humanoidBunnyEntity.m_21824_() || humanoidBunnyEntity.m_21826_() != owner;
        }
        if (target instanceof HumanoidCatEntity) {
            HumanoidCatEntity humanoidCatEntity = (HumanoidCatEntity)target;
            return !humanoidCatEntity.m_21824_() || humanoidCatEntity.m_21826_() != owner;
        }
        if (target instanceof HumanoidDogEntity) {
            HumanoidDogEntity humanoidDogEntity = (HumanoidDogEntity)target;
            return !humanoidDogEntity.m_21824_() || humanoidDogEntity.m_21826_() != owner;
        }
        if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
            return false;
        }
        if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSitting(tag.m_128471_("isSitting"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isSitting", this.isSitting());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public Team m_5647_() {
        return super.m_5647_();
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public HumanoidBunnyVariant getVariant() {
        return HumanoidBunnyVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(HumanoidBunnyVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }
}

